// C++ code
//
/*
  Sweep

  by BARRAGAN <http://barraganstudio.com>
  This example code is in the public domain.

  modified 8 Nov 2013  by Scott Fitzgerald
  http://www.arduino.cc/en/Tutorial/Sweep
*/

#include <LiquidCrystal_I2C.h>

#include <Servo.h>

int pos = 0;

LiquidCrystal_I2C lcd_2(39, 20, 4);

Servo servo_5;
Servo servo_6;

void setup()
{
  lcd_2.init();
  servo_5.attach(5, 500, 2500);
  servo_6.attach(6, 500, 2500);
  Serial.begin(9600);

  lcd_2.print("hello world");
  lcd_2.backlight();
}

void loop()
{
  for (pos = 20; pos <= 160; pos += 1) {
    // tell servo to go to position in variable 'pos'
    servo_5.write(pos);
    //delay(10); // Wait for 15 millisecond(s)
    servo_6.write((160 - pos));
    delay(10); // Wait for 15 millisecond(s)
    lcd_2.setCursor(5, 1);
    lcd_2.print(pos);
    Serial.println(pos);
  }
  for (pos = 160; pos >= 20; pos -= 1) {
    // tell servo to go to position in variable 'pos'
    servo_5.write(pos);
    //delay(10); // Wait for 15 millisecond(s)
    servo_6.write((160 - pos));
    delay(10); // Wait for 15 millisecond(s)
    lcd_2.setCursor(5, 3);
    lcd_2.print(pos);
    Serial.println(pos);
  }
}